Attribute VB_Name = "Winamp"
Option Explicit
Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hWnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function GetSystemMenu Lib "user32" (ByVal hWnd As Long, ByVal bRevert As Long) As Long
Private Declare Function GetSubMenu Lib "user32" (ByVal hMenu As Long, ByVal nPos As Long) As Long
Private Declare Function GetMenuState Lib "user32" (ByVal hMenu As Long, ByVal wID As Long, ByVal wFlags As Long) As Long
Private Declare Function EnumWindows Lib "user32" (ByVal lpEnumFunc As Long, ByVal lParam As Long) As Long

Private Const WM_WA_IPC = &H400
Private Const WM_COMMAND = &H111
Private hwnd_winamp As Long
Private hMenuOptions As Long
Private hMenuWinamp As Long
Private WinampVer As Byte
Private WinampLoaded As Boolean
Private Const IPC_GETOUTPUTTIME = 105
Private Const IPC_SETPLAYLISTPOS = 121
Private Const IPC_SETVOLUME = 122
Private Const IPC_GETLISTLENGTH = 124
Private Const IPC_GETLISTPOS = 125
Private Const WINAMP_BUTTON1 = 40044
Private Const WINAMP_BUTTON2 = 40045
Private Const WINAMP_BUTTON3 = 40046
Private Const WINAMP_BUTTON4 = 40047
Private Const WINAMP_BUTTON5 = 40048
Private Const WINAMP_FILE_QUIT = 40001
Private Const WINAMP_SHUFFLE = 40023
Private Const WINAMP_REPEAT = 40022

Private Type COPYDATASTRUCT
        dwData As Long
        cbData As Long
        lpData As String
End Type

Private Type SONGTITLE
    sName As String
    sArtist As String
    sTrackNumber As String
End Type
Private TrackTitle As SONGTITLE

Private confirmOnFind As Boolean
Public Sub LoadWinamp()
    If GetStuff("Advanced", "Winamp Path") = vbNullString Then
        Shell "C:\Program Files\Winamp\Winamp.exe", vbMinimizedNoFocus
    Else
        Shell GetStuff("Advanced", "Winamp Path"), vbMinimizedNoFocus
    End If
    WinampLoaded = True
End Sub

Private Sub FillWinampValues()
    If WinampVer = 0 Then Exit Sub
    Dim hMenuSystem As Long
    hMenuSystem = GetSystemMenu(hwnd_winamp, 0)
    If WinampVer = 2 Then
        hMenuWinamp = GetSubMenu(hMenuSystem, 0)
        hMenuOptions = GetSubMenu(hMenuWinamp, 11)
    End If
End Sub

Public Function GetSongPosition() As Long
'Finds the current song position in milliseconds
VerifyLoaded
    GetSongPosition = SendMessage(hwnd_winamp, WM_WA_IPC, 0, IPC_GETOUTPUTTIME)
End Function

Public Function GetSongLength() As Long
'Finds the song length in Seconds
VerifyLoaded
    GetSongLength = SendMessage(hwnd_winamp, WM_WA_IPC, 1, IPC_GETOUTPUTTIME)
End Function

Public Function GetPlayListLength() As Long
'Gets amount of songs in play list
VerifyLoaded
    GetPlayListLength = SendMessage(hwnd_winamp, WM_WA_IPC, 0, IPC_GETLISTLENGTH)
End Function

Public Function GetPlayListPosition() As Long
'Returns which song its playing in the playlist
'0 being first
VerifyLoaded
    GetPlayListPosition = SendMessage(hwnd_winamp, WM_WA_IPC, 0, IPC_GETLISTPOS)
End Function

Public Sub SetPlayListPosition(Position As Integer)
'Sets which song to play (0 being first)
VerifyLoaded
    SendMessage hwnd_winamp, WM_WA_IPC, Position, IPC_SETPLAYLISTPOS
End Sub

Public Sub SetVolume(Volume As Integer)
VerifyLoaded
    SendMessage hwnd_winamp, WM_WA_IPC, ParseVolume(Volume), IPC_SETVOLUME
End Sub

Public Sub PreviousTrack()
VerifyLoaded
    SendMessage hwnd_winamp, WM_COMMAND, WINAMP_BUTTON1, 0
End Sub

Public Sub PlaySong(Optional strListPosition As String)
VerifyLoaded
    If strListPosition <> "" Then SetPlayListPosition CInt(strListPosition - 1)
    SendMessage hwnd_winamp, WM_COMMAND, WINAMP_BUTTON2, 0
End Sub

Public Sub PauseSong()
VerifyLoaded
    SendMessage hwnd_winamp, WM_COMMAND, WINAMP_BUTTON3, 0
End Sub

Public Sub StopSong()
VerifyLoaded
    SendMessage hwnd_winamp, WM_COMMAND, WINAMP_BUTTON4, 0
End Sub

Public Sub NextTrack()
VerifyLoaded
    SendMessage hwnd_winamp, WM_COMMAND, WINAMP_BUTTON5, 0
End Sub

Public Sub QuitWinamp()
VerifyLoaded
    SendMessage hwnd_winamp, WM_COMMAND, WINAMP_FILE_QUIT, 0
    WinampLoaded = False
End Sub

Private Function GetSongTitle() As String
On Error Resume Next
VerifyLoaded
Dim sSong_buffer As String * 255
Call GetWindowText(hwnd_winamp, sSong_buffer, 255)
Dim iTrackNumber As Integer
iTrackNumber = InStr(1, sSong_buffer, ".")
TrackTitle.sTrackNumber = Trim$(Left(sSong_buffer, Val(iTrackNumber - 1)))
Dim iArtist As Integer
iArtist = InStr(iTrackNumber, sSong_buffer, "-")
TrackTitle.sArtist = Trim(Mid(sSong_buffer, iTrackNumber + 1, (iArtist - iTrackNumber - 1)))
Dim iSong As Integer
iSong = InStr(iArtist + 1, sSong_buffer, "-")
TrackTitle.sName = Trim(Mid(sSong_buffer, iArtist + 1, (iSong - iArtist - 1)))
GetSongTitle = TrackTitle.sTrackNumber & ". " & TrackTitle.sArtist & " - " & TrackTitle.sName
End Function

Public Sub ToggleShuffle()
VerifyLoaded
SendMessage hwnd_winamp, WM_COMMAND, WINAMP_SHUFFLE, 0
End Sub

Public Sub ToggleRepeat()
VerifyLoaded
SendMessage hwnd_winamp, WM_COMMAND, WINAMP_REPEAT, 0
End Sub

Private Function WConvertTime(TimeSeconds As Long) As String
    Dim TimeMin As Double
    Dim TimeMinOnly As Long
    Dim TimeSecOnly As Long
    
    Dim MinutesStr As String
    Dim SecondsStr As String
    
        TimeMin = (TimeSeconds / 60)
        TimeMinOnly = Int(TimeMin)
        TimeSecOnly = Int((TimeMin - TimeMinOnly) * 60)
        
        If TimeMinOnly < 10 Then
            MinutesStr = "0" & TimeMinOnly
        Else
            MinutesStr = TimeMinOnly
        End If
        
        If TimeSecOnly < 10 Then
            SecondsStr = "0" & TimeSecOnly
        Else
            SecondsStr = TimeSecOnly
        End If

        WConvertTime = MinutesStr & ":" & SecondsStr
End Function

Private Function WinampCF(ByVal hWnd As Long, ByVal lParam As Long) As Long
    Dim strRes$, lR&
    WinampCF = 1
    strRes = String$(255, vbNullChar)
    lR = GetWindowText(hWnd, strRes, 255)
    strRes = Replace(strRes, vbNullChar, "")
    If InStr(strRes, "Winamp") Then
        If StrComp(strRes, "Winamp 1.x", vbTextCompare) = 0 Then
            hwnd_winamp = hWnd
            WinampVer = 2
            FillWinampValues
            WinampCF = 0
        ElseIf StrComp(strRes, "Winamp Library", vbTextCompare) <> 0 And _
            StrComp(strRes, "Winamp Equalizer", vbTextCompare) <> 0 And _
            StrComp(strRes, "Winamp Video", vbTextCompare) <> 0 Then
            If InStr(strRes, " - Winamp") Or InStr(strRes, "Winamp 5") Then
                hwnd_winamp = hWnd
                WinampVer = 5
                WinampCF = 0
            End If
            End If
    End If
End Function

Public Function GetSong() As String
    Dim songLength As Long, elapsedTime As Long
    GetSong = GetSongTitle()
    songLength = GetSongLength()
    elapsedTime = GetSongPosition()
    If elapsedTime = -1 And songLength > -1 Then
        GetSong = GetSong & " [Stopped] [" & WConvertTime(songLength) & "]"
    ElseIf elapsedTime = -1 And songLength = -1 Then
        GetSong = GetSong & " [Stopped]"
    ElseIf elapsedTime > -1 And songLength = -1 Then
        GetSong = GetSong & " [" & WConvertTime(CLng(elapsedTime / 1000&)) & "] [Stream]"
    Else
        GetSong = GetSong & " [" & WConvertTime(CLng(elapsedTime / 1000&)) & " / " & WConvertTime(songLength) & "]"
    End If
End Function

Private Sub FindWinamp(Optional ByVal SendConfirmation As Boolean = False)
    Dim foo As Boolean, eWr&
    If SendConfirmation Then
        confirmOnFind = True
    Else
        confirmOnFind = False
    End If
    foo = True
    eWr = EnumWindows(AddressOf WinampCF, 0)
End Sub

Private Function ParseVolume(Volume As Integer) As Integer
    Select Case Volume
        Case 0: ParseVolume = 0
        Case 1, 2, 3, 4, 5: ParseVolume = 14
        Case 6, 7, 8, 9, 10: ParseVolume = 26
        Case 11, 12, 13, 14, 15: ParseVolume = 40
        Case 16, 17, 18, 19, 20: ParseVolume = 52
        Case 21, 22, 23, 24, 25: ParseVolume = 66
        Case 26, 27, 28, 29, 30: ParseVolume = 78
        Case 31, 32, 33, 34, 35: ParseVolume = 92
        Case 36, 37, 38, 39, 40: ParseVolume = 104
        Case 41, 42, 43, 44, 45: ParseVolume = 118
        Case 46, 47, 48, 49, 50: ParseVolume = 130
        Case 51, 52, 53, 54, 55: ParseVolume = 144
        Case 56, 57, 58, 59, 60: ParseVolume = 156
        Case 61, 62, 63, 64, 65: ParseVolume = 170
        Case 66, 67, 68, 69, 70: ParseVolume = 182
        Case 71, 72, 73, 74, 75: ParseVolume = 196
        Case 76, 77, 78, 79, 80: ParseVolume = 208
        Case 81, 82, 83, 84, 85: ParseVolume = 222
        Case 86, 87, 88, 89, 90: ParseVolume = 234
        Case 91, 92, 93, 94, 95: ParseVolume = 248
        Case 96, 97, 98, 99, 100: ParseVolume = 255
    End Select
End Function

Private Sub VerifyLoaded()
    If hwnd_winamp > 0 Then Exit Sub
    FindWinamp
    Dim s&, i&
    s = GetTickCount() + 200
    While hwnd_winamp = 0 And i < s
        i = GetTickCount()
    Wend
End Sub

